package chess4j.board;

import java.util.List;

import chess4j.Color;
import chess4j.moves.Move;
import chess4j.pieces.Piece;



public interface Board {
	public void addCastlingRight(CastlingRights castlingRight);
	public void addPiece(Piece p,Square s);
	public void applyMove(Move m);
	public boolean canCastle(CastlingRights cr);
	public void clearBoard();
	public Board deepCopy();
	public Square getEPSquare();
	public int getFiftyCounter();
	public Square getKingSquare(Color player);
	public int getMoveCounter();
	public Piece getPiece(Square square);
	public Color getPlayerToMove();
	public List<Square> getSquares(Piece piece);
	public boolean isEmpty(Square square);
	public boolean isOpponentInCheck();
	public boolean isPlayerInCheck();
	public void movePiece(Square from,Square to);
	public void resetBoard();
	public void setEP(Square ep);
	public void swapPlayer();
	public void undoLastMove();
}
